<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Anomaly\Streams\Platform\Model\Repeater\RepeaterReviewRepeaterEntryModel;
use Illuminate\Database\Seeder;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class PageTypeSeed extends Seeder
{
    protected $streamRepository;
    protected $fields;
    protected $assignments;
    protected $typeRepository;
    protected $pageRepository;


    public function __construct(
        StreamRepositoryInterface     $streamRepository,
        FieldRepositoryInterface      $fields,
        AssignmentRepositoryInterface $assignments,
        PageRepositoryInterface       $pageRepository,
        TypeRepositoryInterface       $typeRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->typeRepository = $typeRepository;
        $this->pageRepository = $pageRepository;
    }

    protected $page_fields = [
        'reviewer_field' => [
            'name' => 'Reviewer Field',
            'namespace' => 'pages',
            'slug' => 'reviewer_field',
            'type' => 'anomaly.field_type.repeater',
            'locked' => 0,
            'config' => [
                'related' => RepeaterReviewRepeaterEntryModel::class,
            ],
        ],
        'images' => [
            'name' => 'Images',
            'namespace' => 'pages',
            'slug' => 'images',
            'type' => 'anomaly.field_type.files',
            'locked' => 0,
            'config' => [
                'folders' => ['images'],
                'mode' => 'upload',
                'max' => 2,
            ]
        ]
    ];

    protected $page_types = [
        'default' => [
            'content' => [
                'en'           => [
                    'name'        => 'Default',
                    'description' => 'A simple page type.',
                ],
                'slug'         => 'default',
                'handler'      => 'anomaly.extension.default_page_handler',
                'theme_layout' => 'visiosoft.theme.emlak24m::layouts/page.twig',
                'layout'       => '<h1>{{ page.title }}</h1>{{ page.content.render|raw }}',
            ],
            'fields' => ['content']
        ],
        'about_us' => [
            'content' => [
                'en' => [
                    'name' => 'About Us',
                    'description' => 'About us page type'
                ],
                'slug' => 'about_us',
                'handler' => 'anomaly.extension.default_page_handler',
                'theme_layout' => 'theme::layout/page.twig',
                'layout' => '<div class="row about-us"><div class="col-md-6"><h1>{{ page.title }}</h1>{{ page.content.render|raw }}</div><div class="col-md-6 side-images">{% for image in page.images %}<div class="w-75">{{ img(image.make.url).class(\'w-100\')|raw }}</div>{% endfor %}</div></div>'
            ],
            'fields' => ['content', 'images']
        ],
        'privacy_policy' => [
            'content' => [
                'en' => [
                    'name' => 'Privacy Policy',
                    'description' => 'Privacy policy page type',
                ],
                'slug' => 'privacy_policy',
                'handler' => 'anomaly.extension.default_page_handler',
                'theme_layout' => 'theme::layout/page.twig',
                'layout' => '<div class="privacy_policy"><div class="title"><h1>{{ page.title }}</h1><p>{{ trans(\'theme::field.last_updated_date\') }}: {{ page.updated_at|date(\'d.m.Y\') }}</p></div><div class="col-12">{{ page.content.render|raw }}</div></div>',
            ],
            'fields' => ['content']
        ],
    ];

    public function run()
    {
        foreach ($this->page_fields as $slug => $item) {
            if (!$this->fields->findBySlugAndNamespace($slug, $item['namespace'])) {
                $this->fields->create($item);
            }
        }

        foreach ($this->page_types as $slug => $item) {
            if (!$type = $this->typeRepository->findBySlug($slug)) {
                $type = $this->typeRepository->create($item['content']);
            }

            $stream = $type->getEntryStream();


            foreach ($item['fields'] as $field_slug) {
                if (($field = $this->fields->findBySlugAndNamespace($field_slug, 'pages')) && !$this->assignments->findByStreamAndField($stream, $field)) {
                    $this->assignments->create([
                        'stream' => $stream,
                        'field' => $field
                    ]);
                }
            }
        }
    }
}
