var current_page = 1;
var records_per_page = ads_per_page;
var ads_type = "";

var objJson = [];
let totalAdvs = 0

function prevPage() {
    if (current_page > 1) {
        current_page--;
        getMyAdvs(ads_type)
    }
}

function nextPage() {
    if (current_page < numPages()) {
        current_page++;
        getMyAdvs(ads_type)
    }
}

function changePage(page) {
    var btn_next = $("#btn_next");
    var btn_prev = $("#btn_prev");
    var listing_table = $("#nav-" + ads_type);
    var page_span = $("#page");

    // Validate page
    if (page < 1) page = 1;
    if (page > numPages()) page = numPages();

    listing_table.html("");

    if (objJson.length === 0) {
        listing_table.html(`
            <div class="alert alert-warning" role="alert">
                ${no_ads_message}
            </div>
        `);
    }

    objJson.map((value) => {
        listing_table.append(addAdsRow(value.id, value.detail_url, value.cover_photo, value.name,
            value.formatted_price, value.city_name, value.country_name, value.status, value.date,value.count_show_ad));

    })

    addDropdownBlock()

    page_span.html(page + "/" + numPages());

    if (numPages() === 1) {
        page_span.hide();
    } else {
        page_span.show();
    }

    if (page === 1) {
        btn_prev.hide();
    } else {
        btn_prev.show();
    }

    if (page === numPages()) {
        btn_next.hide();
    } else {
        btn_next.show();
    }
}

function numPages() {
    return Math.ceil(totalAdvs / records_per_page);
}

function getMyAdvs(type, search = null) {
    crudAjax({'type': type, 'paginate': true, 'page': current_page, 'search': search}, '/ajax/getAdvs', 'GET', function (callback) {
        ads_type = type;
        objJson = callback.content.data;
        totalAdvs = callback.content.total
        changePage(current_page);

        $('.profile-advs-tab .nav-item').filter((_index, value) => {
            if ($(value).data('type') === type) {
                $(value).find('.ad-count').html(callback.content.total)
                $(`#title-${type}`).find('.ad-count').html(callback.content.total)
            }
        })
    })
}

$('.profile-advs-tab a').on('click', function () {
    current_page = 1
    getMyAdvs($(this).attr('data-type'))
});

function addAdsRow(id, href, image, name, formatted_price, city, country, status, date, count_show_ad) {
    city =  (city) ? city : '';
    country =  (country) ? country : '';
    return `
        <div class='col-md-12 mb-2 profile-ads'>
            <div class='row border'>
                <div class='col-md-3 justify-content-center align-self-center p-0 ad-image'>
                    <img class='img-thumbnail border-0 p-0 position-relative' src='${image}' alt='${name}'>
                    <span class="text-uppercase position-absolute w-100 text-center text-white">${ads_no}: ${id}</span>
                </div>
                <div class='col-md-9 pt-3'>
                    <div class='row'>
                        <div class='col-md-8'>
                            <div class='row'>
                                <div class="col-12">
                                    <a href='${href}' class='text-dark'>
                                        <p class="ad-name mb-0">${name}</p>
                                    </a>
                                </div>
                                <div class='col-md-12 location'>
                                    ${city} ${country}
                                </div>
                                <div class='col-md-12 price'>
                                    ${formatted_price}
                                </div>
                            </div>
                        </div>
                        <div class='col-md-4 text-right'>
                            <div class="row">
                                <div class="col-12 date mb-3">
                                    ${ad_created_date}: ${date}
                                </div>
                                <div class="col-12 ">
                                    ${dropdownRow(id, status)}                                            
                                </div>
                                <div class="col-12 mt-2 d-flex">
                                    <div class="ml-auto" style="padding:4px; border: 1px solid; border-color: #e8e8e8; border-radius: 0; display: flex; align-items: center; font-weight: 300; color: #7a7a7a;">
                                        ${show_count_trans} : &nbsp; ${count_show_ad}                                            
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;
}

function dropdownRow(id, type) {
    let dropdown = `<div class='dropdown my-ads-dropdown' data-id='${id}'>
        <button class='dropdown-toggle btn btn-outline-dark' type='button' id='dropdownMenuButton' data-toggle='dropdown'>
        ${choose} <i class="fa fa-angle-down ml-1" aria-hidden="true"></i>
        </button>
        <div class='dropdown-menu' aria-labelledby='dropdownMenuButton'>`;

    if (type === "passive") {
        dropdown += `<a class='dropdown-item text-success' href='/advs/status/${id},approved'>
            <i class='fas fa-eye'></i> 
            ${approve}
            </a>`;
    } else {
        dropdown += `<a class='dropdown-item text-secondary' href='/advs/status/${id},passive'>
            <i class='fas fa-eye-slash'></i>
            ${passive}
            </a>`;
    }

    dropdown += `<a class='dropdown-item text-primary' href='/advs/edit_advs/${id}'>
        <i class='fas fa-pencil-alt'></i>
        ${edit_ad}
        </a>`;

    dropdown += `<a class='dropdown-item text-danger' href='/advs/delete/${id}'>
        <i class='fas fa-trash'></i>
        ${delete_ad}
        </a>`;

    dropdown += `<a class='dropdown-item text-info' href='/advs/extend/${id}'> 
        <i class='fas fa-calendar'></i>
        ${extend_ad}
        </a>`;

    if (Object.keys(userStatus).length) {
        let statusItems = ''
        for (const status in userStatus) {
            statusItems += `
            <li>
                <a class="dropdown-item"
                    href="${statusChangeLink.replace(':adID', id).replace(':statusID', status)}">
                    ${userStatus[status]}
                </a>
            </li>
        `
        }

        dropdown += `
        <li class="dropdown-submenu dropleft">
            <button type="button" class="btn dropdown-item dropdown-toggle">${changeStatusTrans}</button>
            <ul class="dropdown-menu">
                ${statusItems}
            </ul>
          </li>
        `;
    }

    dropdown += "</div></div>";

    return dropdown;
}

function addDropdownBlock() {
    $('.my-ads-dropdown').map((_index, value) => {
        $('> .dropdown-menu', value).append(dropdownBlock.replace(':id', $(value).data('id')))
    })
}

// Nested dropdown
$('.tab-pane').on('click', '.dropdown-menu button.dropdown-toggle', function() {
    if (!$(this).next().hasClass('show')) {
        $(this).parents('.dropdown-menu').first().find('.show').removeClass('show');
    }
    var $subMenu = $(this).next('.dropdown-menu');
    $subMenu.toggleClass('show');

    $(this).parents('.my-ads-dropdown.show').on('hidden.bs.dropdown', function(e) {
        $('.dropdown-submenu .show').removeClass('show');
    });

    return false;
});

$(() => {
    const ad_type_item = $('.profile-advs-tab .nav-item');

    ad_type_item.map((_i, el) => {
        current_page = 1;
        getMyAdvs($(el).data('type'));
    })

    ad_type_item.on('click', (e) => {
        const clicked_item = $(e.currentTarget)
        $('#nav-tabContent').removeClass('d-none')
        $('.profile-advs-tab').addClass('d-none');
        $(`#nav-${clicked_item.data('type')}`).addClass('show active')
        $(`#title-${clicked_item.data('type')}`).removeClass('d-none')
        getMyAdvs(clicked_item.attr('data-type'))
    })

    $('.back-to-ad-tab').on('click', () => {
        $('#nav-tabContent').addClass('d-none')
        $('.profile-advs-tab').removeClass('d-none');
        $('.tab-pane').removeClass('show active')
        $('.page-title').addClass('d-none')
    })

    $('.my-ad-search').on('keyup', (e) => {
        getMyAdvs(ads_type, $(e.currentTarget).val())
    })
})
