<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\SettingsModule\Setting\SettingRepository;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class SettingSeed extends Seeder
{
    protected $categoryRepository;
    protected $settingRepository;

    public function __construct(SettingRepositoryInterface $settingRepository, CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
        $this->settingRepository = $settingRepository;
    }

    public function run()
    {
        if ($category = $this->categoryRepository->findBySlug('projects')) {
            $this->settingRepository->set('visiosoft.theme.emlak24m::select_project_category', $category->getId());
        }
    }
}
