<?php namespace Visiosoft\Emlak24mTheme\Command;

use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;

class GetTrans
{
    public function handle()
    {
        $translations = [
            'or' => trans("theme::field.or"),
            'services' => trans("theme::field.services"),
            'take_a_look_at_our_services' => trans("theme::field.take_a_look_at_our_services"),
            'get_offers_from_best_agents' => trans('theme::field.get_offers_from_best_agents'),
            'get_best_options_for_you_in_24_hours' => trans('theme::field.get_best_options_for_you_in_24_hours'),
            'what_are_you_looking_for' => trans('theme::field.what_are_you_looking_for'),
            'what_are_you_selling' => trans('theme::field.what_are_you_selling'),
            'back_button' => trans('theme::field.back_button'),
            'thank_you' => trans('theme::field.thank_you'),
            'fill_your_info' => trans('theme::field.fill_your_info'),
            'where_are_you_looking' => trans('theme::field.where_are_you_looking'),
            'price_range' => trans('theme::field.price_range'),
            'our_moving_assistant_services' => trans('theme::field.our_moving_assistant_services'),
            'we_are_with_you_in_the_process_of_getting' => trans('theme::field.we_are_with_you_in_the_process_of_getting', [
                'site_name' => setting_value('streams::name')
            ]),
            'discounted_shipping_service' => trans('theme::field.discounted_shipping_service'),
            'free_tcip_policy' => trans('theme::field.free_tcip_policy'),
            'discounted_furniture_buying_selling' => trans('theme::field.discounted_furniture_buying_selling'),
            'site_find_me_home_line' => trans('theme::field.site_find_me_home_line', [
                'site_name' => setting_value('streams::name')
            ]),
            'find_me_home' => trans('theme::field.find_me_home'),
            'close' => trans('theme::field.close'),
            'city' => trans('theme::field.city'),
            'choose_city' => trans('theme::field.choose_city'),
            'district' => trans('theme::field.district'),
            'choose_district' => trans('theme::field.choose_district'),
            'neighborhood' => trans('theme::field.neighborhood'),
            'choose_neighborhood' => trans('theme::field.choose_neighborhood'),
            'continue_button' => trans('theme::field.continue_button'),
            'turkey' => trans('theme::field.turkey'),
            'min_budget' => trans('theme::field.min_budget'),
            'max_budget' => trans('theme::field.max_budget'),
            'min_price' => trans('theme::field.min_price'),
            'min_budget_less_than_max' => trans('theme::field.min_budget_less_than_max'),
            'services_valuation_detail_ph' => trans('theme::field.services_valuation_detail_ph'),
            'any_details_you_would_like_to_share' => trans('theme::field.any_details_you_would_like_to_share'),
            'where_do_you_need_this_service' => trans('theme::field.where_do_you_need_this_service'),
            'housing' => trans('theme::field.housing'),
            'land' => trans('theme::field.land'),
            'full_name' => trans('theme::field.full_name'),
            'your_full_name' => trans('theme::field.your_full_name'),
            'email' => trans('theme::field.email'),
            'enter_email' => trans('theme::field.enter_email'),
            'phone' => trans('theme::field.phone'),
            'enter_phone' => trans('theme::field.enter_phone'),
            'i_read_and_accept' => trans('theme::field.i_read_and_accept'),
            'terms_of_service' => trans('theme::field.terms_of_service'),
            'apply' => trans('theme::field.apply'),
            'demand_request_success' => trans('theme::field.demand_request_success'),
            'demand_request_error' => trans('theme::field.demand_request_error'),
            'loading' => trans('theme::field.loading'),
            'create_for_your_references' => trans('theme::field.create_for_your_references'),
            'contact' => trans('theme::field.contact'),
            'buy' => trans('theme::field.buy'),
            'sell' => trans('theme::field.sell'),
            'lend' => trans('theme::field.lend'),
        ];

        $fieldRepository = app(FieldRepositoryInterface::class);
        $fieldsSlug = ['service_type', 'to_where', 'from_where', 'credit_amount', 'address', 'details', 'service_area',
            'plot_no', 'block_no', 'property_type'];
        $fields = $fieldRepository->newQuery()->where('namespace', 'demand')
            ->whereIn('slug', $fieldsSlug)->get();

        foreach ($fields as $field) {
            $translations[$field->slug] = $field->name;
        }

        return $translations;
    }
}
