<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\NavigationModule\Link\LinkModel;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;
use Illuminate\Database\Seeder;

class NavigationSeed extends Seeder
{
    protected $menuRepository;
    protected $linkRepository;

    public function __construct(MenuRepositoryInterface $menuRepository, LinkModel $linkModel, LinkRepositoryInterface $linkRepository)
    {
        $this->menuRepository = $menuRepository;
        $this->linkRepository = $linkRepository;
    }

    public function run()
    {
        $menus = [
            [
                'en' => [
                    'name' => 'Company',
                ],
                'slug' => 'footer_company',
            ], [
                'en' => [
                    'name' => 'Buy and Sell',
                ],
                'slug' => 'footer_buy_and_sell',
            ], [
                'en' => [
                    'name' => 'Membership & Services',
                ],
                'slug' => 'footer_membership_and_services',
            ], [
                'en' => [
                    'name' => 'Policies',
                ],
                'slug' => 'policies',
            ]

        ];

        foreach ($menus as $menu) {
            if (!$this->menuRepository->findBySlug($menu['slug'])) {
                $this->menuRepository->create($menu);
            }
        }

        $links = [
            [
                'entry' => [
                    'en' => [
                        'title' => 'About Us',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_company'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Contact',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_company'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Tag',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_company'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Career',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_company'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Advertising',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_buy_and_sell'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Buy Services & Packages',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_membership_and_services'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Register as Sales Partner',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_membership_and_services'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Register as Real Estate Agent',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_membership_and_services'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Register as Real Estate Developer',
                    ],
                    'url' => '#',
                ],
                'menu' => 'footer_membership_and_services'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Privacy Policy',
                    ],
                    'url' => '#',
                ],
                'menu' => 'policies'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Cookie Policy',
                    ],
                    'url' => '#',
                ],
                'menu' => 'policies'
            ],
            [
                'entry' => [
                    'en' => [
                        'title' => 'Terms & Conditions',
                    ],
                    'url' => '#',
                ],
                'menu' => 'policies'
            ],
        ];

        foreach ($links as $link) {
            $menu = $this->menuRepository->findBySlug($link['menu']);
            $url = new UrlLinkTypeModel();

            $entry = $url->newQuery()->create($link['entry']);

            $this->linkRepository->create([
                'menu' => $menu,
                'target' => '_blank',
                'entry' => $entry,
                'type' => 'anomaly.extension.url_link_type'
            ]);
        }
    }
}
