<?php namespace Visiosoft\Emlak24mTheme\Http\Controller;

use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\PostsModule\Post\Contract\PostRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;


class PostController extends PublicController
{
    protected $postCategoryRepository, $postRepository;

    public function __construct(CategoryRepositoryInterface $postCategoryRepository,
                                PostRepositoryInterface     $postRepository)
    {
        $this->postRepository = $postRepository;
        $this->postCategoryRepository = $postCategoryRepository;
        parent::__construct();
    }

    public function index() {
        $magazineCategory = $this->postCategoryRepository->findBySlug('magazine');
        $newsCategory = $this->postCategoryRepository->findBySlug('news');
        $magazineCategoryId = null;
        $newsCategoryId = null;
        $magazines = [];
        $news = [];
        if (!empty($magazineCategory)) {
            $magazineCategoryId = $magazineCategory['id'];
        }
        if (!empty($newsCategory)) {
            $newsCategoryId = $newsCategory['id'];
        }
        if (!empty($newsCategoryId)) {
            $news = $this->postRepository
                ->newQuery()
                ->where('category_id', setting_value('visiosoft.theme.emlak24m::news_category_id'))
                ->orderBy('created_at', 'desc')
                ->take(setting_value('visiosoft.theme.emlak24m::news_items_limit'))
                ->get();
        }
        if (!empty($magazineCategory)) {
            $magazines = $this->postRepository
                ->newQuery()
                ->where('category_id', setting_value('visiosoft.theme.emlak24m::magazine_category_id'))
                ->orderBy('created_at', 'desc')
                ->take(setting_value('visiosoft.theme.emlak24m::magazine_items_limit'))
                ->get();
        }
        return $this->view->make('visiosoft.theme.emlak24m::posts/magazine', compact(
            'news', 'magazines'
        ));
    }
}