<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterUrlRepeaterEntryModel;
use Illuminate\Database\Seeder;
use Anomaly\PostsModule\Post\Contract\PostRepositoryInterface;
use Anomaly\PostsModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class PostSeed extends Seeder
{
    protected $streamRepository;
    protected $fields;
    protected $assignments;
    protected $typeRepository;
    protected $postRepository;
    protected $postCategoryRepository;

    public function __construct(
        StreamRepositoryInterface     $streamRepository,
        FieldRepositoryInterface      $fields,
        AssignmentRepositoryInterface $assignments,
        CategoryRepositoryInterface   $postCategoryRepository,
        PostRepositoryInterface       $postRepository,
        TypeRepositoryInterface       $typeRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->postRepository = $postRepository;
        $this->postCategoryRepository = $postCategoryRepository;
        $this->typeRepository = $typeRepository;
    }

    protected $post_fields = [
        'url_field' => [
            'name' => 'URL Field',
            'namespace' => 'posts',
            'slug' => 'url_field',
            'type' => 'anomaly.field_type.url',
            'locked' => 0,
            'config' => [
            ],
        ],
        'image_field' => [
            'name' => 'Image Field',
            'namespace' => 'posts',
            'slug' => 'image_field',
            'type' => 'anomaly.field_type.file',
            'locked' => 0,
            'config' => [
                'folders' => ["images"]
            ],
        ],
    ];

    protected $post_categories = [
        [
            'en' => [
                'name' => 'Magazine',
                'description' => 'Magazine Category Description'
            ],
            'slug' => 'magazine'
        ],
        [
            'en' => [
                'name' => 'News',
                'description' => 'News Category Description'
            ],
            'slug' => 'news'
        ]
    ];

    public function run()
    {
        foreach ($this->post_fields as $slug => $item) {
            if (!$field = $this->fields->findBySlugAndNamespace($slug, $item['namespace'])) {
                $field = $this->fields->create($item);
            }
            if ($type = $this->typeRepository->findBySlug('default')) {
                $stream = $type->getEntryStream();
                if (!$this->assignments->findByStreamAndField($stream, $field)) {
                    $this->assignments->create([
                        'stream' => $stream,
                        'field' => $field
                    ]);
                }
            }
        }
        foreach ($this->post_categories as $item) {
            $category = $this->postCategoryRepository->findBySlug($item['slug']);
            if (empty($category)) {
                $this->postCategoryRepository->create($item);
            }
        }
    }
}
