<?php namespace Visiosoft\Emlak24mTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;

class Emlak24mThemeServiceProvider extends AddonServiceProvider
{
    protected $overrides = [
        'anomaly.module.users::login' => 'visiosoft.theme.base::addons/anomaly/users-module/login',
        'anomaly.module.users::register' => 'visiosoft.theme.base::addons/anomaly/users-module/register',
        'anomaly.module.users::password/forgot' => 'visiosoft.theme.base::addons/anomaly/users-module/password/forgot',
        'anomaly.module.users::password/reset' => 'visiosoft.theme.base::addons/anomaly/users-module/password/reset',
    ];

    protected $routes = [
        '/magazine' => [
            'as' => 'magazine',
            'uses' => 'Visiosoft\Emlak24mTheme\Http\Controller\PostController@index',
        ],
        'ajax/get-locales' => [
            'as' => 'get-locales',
            'uses' => 'Visiosoft\Emlak24mTheme\Http\Controller\LocaleController@getLocales'
        ],
        'ajax/set-locale/{locale}' => [
            'as' => 'set-locale',
            'uses' => 'Visiosoft\Emlak24mTheme\Http\Controller\LocaleController@setLocale'
        ]
    ];
    protected $plugins = [
        Emlak24mThemePlugin::class,
    ];
}
