let map, geocoder, infoWin

function initMap() {
    const options = {
        zoom: 15,
    };
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), options);
    infoWin = new google.maps.InfoWindow();

    geocodeAddress(defaultCountry.name)

    google.maps.event.addListener(map, 'idle', function (event) {
        if (map.center) {
            const lat = map.center.lat()
            const lng = map.center.lng()

            crudAjax({lat, lng}, '/api/classified/get-by-coordinates', 'GET', () => {}, true)
                .then(res => {
                    if (res.success) {
                        const classifieds = res.classifieds
                        classifieds.map((value) => {
                            const coordinate = value.map_Val.split(',')
                            createMarker({lat: Number(coordinate[0]), lng: Number(coordinate[1])}, value)
                        })
                    } else {
                        alert(res.msg)
                    }
                })
        }
    });
}

function geocodeAddress(address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            map.setCenter(results[0].geometry.location);
            map.fitBounds(results[0].geometry.viewport)
        }
    });
}

function createMarker(latLng, classified) {
    const marker = new google.maps.Marker({
        map,
        position: latLng,
        icon: mapPin
    });
    google.maps.event.addListener(marker, 'click', function () {
        infoWin.setContent(`
            <div id="content" class="col-md-12 p-0 m-0">
                <div class="map_info_top"></div>
                <div id="bodyContent">
                    <p>
                        <img class="map_image w-100" src="${classified.cover_photo}" height="auto"/>
                    </p>
                    <h6 class="map_subject text-truncate text-primary">${classified.name}</h6>
                    <p class="map_price">${classified.price + ' ' + classified.currency}</p>
                    <p>
                        <a href="${classified.detail_url}" class="btn btn-info w-100" target="_blank">
                            <small>${showDetailsTrans}</small>
                        </a>
                    </p>
                </div>
            </div>
        `);
        infoWin.open(map, marker);
        infoWin.setStyle('map_subject')
    });
}

$('#locationInputWrapper').submit(function (e) {
    e.preventDefault()

    const location = $('#searchLocationInput').val()
    if (location) {
        geocodeAddress(location);
    }
})

// Dynamic placeholder
var SuperPlaceholder = function(options) {
    this.options = options;
    this.element = options.element
    this.placeholderIdx = 0;
    this.charIdx = 0;


    this.setPlaceholder = function() {
        placeholder = options.placeholders[this.placeholderIdx];
        var placeholderChunk = placeholder.substring(0, this.charIdx+1);
        document.querySelector(this.element).setAttribute("placeholder", this.options.preText + " " + placeholderChunk)
    };

    this.onTickReverse = function(afterReverse) {
        if (this.charIdx === 0) {
            afterReverse.bind(this)();
            clearInterval(this.intervalId);
            this.init();
        } else {
            this.setPlaceholder();
            this.charIdx--;
        }
    };

    this.goReverse = function() {
        clearInterval(this.intervalId);
        this.intervalId = setInterval(this.onTickReverse.bind(this, function() {
            this.charIdx = 0;
            this.placeholderIdx++;
            if (this.placeholderIdx === options.placeholders.length) {
                // end of all placeholders reached
                this.placeholderIdx = 0;
            }
        }), this.options.speed)
    };

    this.onTick = function() {
        var placeholder = options.placeholders[this.placeholderIdx];
        if (this.charIdx === placeholder.length) {
            // end of a placeholder sentence reached
            setTimeout(this.goReverse.bind(this), this.options.stay);
        }

        this.setPlaceholder();

        this.charIdx++;
    }

    this.init = function() {
        this.intervalId = setInterval(this.onTick.bind(this), this.options.speed);
    }

    this.kill = function() {
        clearInterval(this.intervalId);
    }
}

if (mapPlaceholder && mapPlaceholder.length) {
    window.onload = function() {
        var sp = new SuperPlaceholder({
            placeholders: mapPlaceholder,
            preText: "",
            stay: 250,
            speed: 100,
            element: '#searchLocationInput'
        });
        sp.init();
    }
}
