<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class CategorySeed extends Seeder
{
    protected $categoryRepository;

    public function __construct(CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function run()
    {
        $categories = ['Projects', 'Real Estate'];

        foreach ($categories as $category) {
            $slug = Str::slug($category, '_');
            if (!$this->categoryRepository->findBySlug($slug)) {
                $this->categoryRepository->create([
                    'name' => $category,
                    'slug' => $slug,
                    'parent_category_id' => NULL,
                    'level' => 1,
                ]);
            }
        }
    }
}
