<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Anomaly\Streams\Platform\Model\Repeater\RepeaterReviewRepeaterEntryModel;
use Illuminate\Database\Seeder;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class PageSeed extends Seeder
{
    protected $streamRepository;
    protected $fields;
    protected $assignments;
    protected $typeRepository;
    protected $pageRepository;


    public function __construct(
        StreamRepositoryInterface     $streamRepository,
        FieldRepositoryInterface      $fields,
        AssignmentRepositoryInterface $assignments,
        PageRepositoryInterface       $pageRepository,
        TypeRepositoryInterface       $typeRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->typeRepository = $typeRepository;
        $this->pageRepository = $pageRepository;
    }

    protected $page_fields = [
        'reviewer_field' => [
            'name' => 'Reviewer Field',
            'namespace' => 'pages',
            'slug' => 'reviewer_field',
            'type' => 'anomaly.field_type.repeater',
            'locked' => 0,
            'config' => [
                'related' => RepeaterReviewRepeaterEntryModel::class,
            ],
        ],
    ];

    public function run()
    {
        foreach ($this->page_fields as $slug => $item) {
            if (!$field = $this->fields->findBySlugAndNamespace($slug, $item['namespace'])) {
                $field = $this->fields->create($item);
            }

            if ($type = $this->typeRepository->findBySlug('default')) {
                $stream = $type->getEntryStream();

                if (!$this->assignments->findByStreamAndField($stream, $field)) {
                    $this->assignments->create([
                        'stream' => $stream,
                        'field' => $field
                    ]);
                }
            }
        }
    }
}
