<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Illuminate\Database\Seeder;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class PageSeed extends Seeder
{
    protected $streamRepository;
    protected $fields;
    protected $assignments;
    protected $typeRepository;
    protected $pageRepository;


    public function __construct(
        StreamRepositoryInterface     $streamRepository,
        FieldRepositoryInterface      $fields,
        AssignmentRepositoryInterface $assignments,
        PageRepositoryInterface       $pageRepository,
        TypeRepositoryInterface       $typeRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->typeRepository = $typeRepository;
        $this->pageRepository = $pageRepository;
    }

    protected $pages = [
        'about_us' => [
            'content' => [
                'en' => [
                    'title' => 'About Us',
                ],
                'slug' => 'about_us',
                'enabled' => true,
                'home' => false,
                'theme_layout' => 'visiosoft.theme.emlak24m::layouts/page.twig',
            ],
            'entry_content' => [
                'en' => [
                    'content' => '<p>You want to invest by purchasing real estate such as a house, land or workplace in Turkey or to sell your real estate in Turkey at their real value quickly and reliably; but if you don\'t have the time and expertise to go to Turkey and follow the processes properly, let us introduce you to Emlak 24!</p>',
                ],
            ],
            'type' => 'about_us',
        ],
        'privacy_policy' => [
            'content' => [
                'en' => [
                    'title' => 'Privacy Policy',
                ],
                'slug' => 'privacy_policy',
                'enabled' => true,
                'home' => false,
                'theme_layout' => 'visiosoft.theme.emlak24m::layouts/page.twig',
            ],
            'entry_content' => [
                'en' => [
                    'content' => '<p>This Privacy Policy describes Our policies and procedures on the collection, use and disclosure of Your information when You use the Service and tells You about Your privacy rights and how the law protects You.</p><p>This Privacy Policy describes Our policies and procedures on the collection, use and disclosure of Your information when You use the Service and tells You about Your privacy rights and how the law protects You.</p>'
                ],
            ],
            'type' => 'privacy_policy'
        ]
    ];

    public function run()
    {
        foreach ($this->pages as $page) {
            if(!$this->pageRepository->findByPath('/'. str_slug($page['content']['slug'], '-'))) {
                $type = $this->typeRepository->findBySlug($page['type']);
                $selected_type = [];

                foreach ($page['entry_content'] as $content) {
                    $selected_type = [
                        'type' => $type,
                        'entry' => $type->getEntryModel()->newQuery()->create($content)
                    ];
                }

                $page = array_merge($page['content'], $selected_type);
                $this->pageRepository->create($page);
            }
        }
    }
}
