<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;

class MiddleSectionSeed extends Seeder
{

    private $areaRepository;
    private $blocksTypeRepository;
    private $fieldRepository;
    private $assignmentRepository;
    private $streamRepository;
    private $blockRepository;

    public function __construct(
        AreaRepositoryInterface $areaRepository,
        TypeRepositoryInterface $blocksTypeRepository,
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository,
        BlockRepositoryInterface $blockRepository
    ) {
        $this->areaRepository = $areaRepository;
        $this->blocksTypeRepository = $blocksTypeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
        $this->blockRepository = $blockRepository;
    }

    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Create block area
        if ($middleSectionArea = $this->areaRepository->findBySlug('middle-section')) {
            $middleSectionArea->delete();
        }
        $middleSectionArea = $this->areaRepository->create([
            'name' => trans('visiosoft.theme.emlak24m::field.middle_section'),
            'slug' => 'middle-section',
        ]);

        // Create block type
        if ($blockType = $this->blocksTypeRepository
            ->getModel()
            ->withTrashed()
            ->where('slug', 'responsive_two_columns')
            ->first()) {
            $blockType->forceDelete();
        }
        $blockType = $this->blocksTypeRepository->create([
            'name' => trans('visiosoft.theme.emlak24m::field.responsive_two_columns'),
            'slug' => 'responsive_two_columns',
            'category' => 'content',
            'content_layout' => '<div class="container py-4 world-partner">
                                    <h2 class="mb-3">{{ block.title }}</h2>
                                    <div class="row">
                                        <div class="col-12 col-md-6 mx-auto">
                                            <p class="lead">{{ block.first_column }}</p>
                                        </div>
                                        <div class="col-12 col-md-6 mx-auto">
                                            <p class="lead">{{ block.second_column }}</p>
                                        </div>
                                    </div>
                                </div>',
            'wrapper_layout' => '{% extends "anomaly.module.blocks::types.wrapper" %}'
        ]);

        // Create block stream
        if (!$responsiveTwoColumnsBlock = $this->streamRepository
            ->findBySlugAndNamespace('responsive_two_columns_blocks', 'blocks')) {
            $responsiveTwoColumnsBlock = $this->streamRepository->create([
                'name' => trans('visiosoft.theme.emlak24m::field.responsive_two_columns'),
                'namespace' => 'blocks',
                'slug' => 'responsive_two_columns_blocks',
                'prefix' => 'blocks_',
                'translatable' => 1,
            ]);
        }

        // Create block fields
        $blocksFields = [
            'first_column' => [
                'name' => trans('visiosoft.theme.emlak24m::field.first_column'),
                'namespace' => 'blocks',
                'slug' => 'first_column',
                'type' => 'anomaly.field_type.textarea'
            ],
            'second_column' => [
                'name' => trans('visiosoft.theme.emlak24m::field.second_column'),
                'namespace' => 'blocks',
                'slug' => 'second_column',
                'type' => 'anomaly.field_type.textarea'
            ]
        ];
        foreach ($blocksFields as $blocksField) {
            if ($field = $this->fieldRepository->findBySlugAndNamespace($blocksField['slug'], $blocksField['namespace'])) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $blocksField['name'],
                'namespace' => $blocksField['namespace'],
                'slug' => $blocksField['slug'],
                'type' => $blocksField['type'],
                'locked' => 0
            ]);
            $this->assignmentRepository->create([
                'stream_id' => $responsiveTwoColumnsBlock->getId(),
                'field_id' => $field->id,
                'label' => $blocksField['name'],
                'translatable' => 1,
            ]);
        }

        // Add default instructions
        $blockFieldId = $this->fieldRepository->findBySlugAndNamespace('blocks', 'blocks')->getId();
        $block = $this->blockRepository->create([
            'title' => trans('visiosoft.theme.emlak24m::field.my_partner.title'),
            'field' => $blockFieldId,
            'extension' => 'anomaly.extension.responsive_two_columns_block',
            'display_title' => false,
        ]);
        $blockInfo = app('Anomaly\Streams\Platform\Model\Blocks\BlocksResponsiveTwoColumnsBlocksEntryModel')
            ->newQuery()->create([
                'first_column' => trans('visiosoft.theme.emlak24m::field.my_partner.part_1'),
                'second_column' => trans('visiosoft.theme.emlak24m::field.my_partner.part_2')
            ]);
        $block->update([
            'area_id' => $middleSectionArea->getId(),
            'area_type' => get_class($middleSectionArea),
            'entry_id' => $blockInfo->id,
            'entry_type' => get_class($blockInfo),
        ]);
    }
}
