<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Illuminate\Database\Seeder;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class RepeaterSeed extends Seeder
{
    protected $streamRepository;
    protected $fields;
    protected $assignments;

    public function __construct(
        StreamRepositoryInterface     $streamRepository,
        FieldRepositoryInterface      $fields,
        AssignmentRepositoryInterface $assignments
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fields = $fields;
        $this->assignments = $assignments;
    }

    protected $repeaters = [
        'review_repeater' => [
            'content' => [
                'name' => 'Review Repeater',
                'namespace' => 'repeater',
                'prefix' => 'repeater_',
                'slug' => 'review_repeater',
                'translatable' => true,
            ],
            'fields' => ['image', 'name', 'description']
        ],
    ];
    protected $repeater_fields = [
        'name' => [
            'field_attributes' => [
                'name' => 'Name',
                'namespace' => 'repeater',
                'slug' => 'name',
                'type' => 'anomaly.field_type.text',
                'locked' => 0,
                'config' => [],
            ],
            'assignment_attributes' => [
                'required' => true,
                'translatable' => false,
            ]
        ],
        'description' => [
            'field_attributes' => [
                'name' => 'Description',
                'namespace' => 'repeater',
                'slug' => 'description',
                'type' => 'anomaly.field_type.textarea',
                'locked' => 0,
                'config' => [],
            ],
            'assignment_attributes' => [
                'required' => true,
                'translatable' => true,
            ]
        ],
        'image' => [
            'field_attributes' => [
                'name' => 'Image',
                'namespace' => 'repeater',
                'slug' => 'image',
                'type' => 'anomaly.field_type.file',
                'locked' => 0,
                'config' => [
                    'folders' => ['images'],
                    'mode' => 'upload',
                ],
            ],
            'assignment_attributes' => [
                'required' => true,
                'translatable' => false,
            ],
        ],
    ];

    public function run()
    {
        foreach ($this->repeaters as $slug => $arr) {
            if (!$repeater = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater = $this->streamRepository->create($arr['content']);
            }

            foreach ($this->repeater_fields as $field_slug => $field_repeater) {
                if (!$field = $this->fields->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fields->create($field_repeater['field_attributes']);
                }

                if (!$this->assignments->findByStreamAndField($repeater, $field) && in_array($field->getSlug(), $arr['fields'], true)) {
                    $this->assignments->create(
                        array_merge([
                            'stream' => $repeater,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }
    }
}
