<?php namespace Visiosoft\Emlak24mTheme\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Image\Image;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Traits\ApiReturnResponseTrait;


class LocaleController extends PublicController
{
    use ApiReturnResponseTrait;

    protected $image;

    public function __construct(Image $image)
    {
        parent::__construct();
        $this->image = $image;
    }

    public function getLocales()
    {
        try {
            $data = [];
            $locales = config('streams::locales.enabled');
            $data['current_locale']['language'] = trans('streams::locale.' . config('app.locale') . '.name');
            foreach ($locales as $locale) {
                $image = '';
                $imageFile = $this->image->make('theme::images/flags/' . $locale . '.svg', 'path');
                if (!empty($imageFile)) {
                    $image = $imageFile->url();
                }
                $language = trans('streams::locale.' . $locale . '.name');
                if ($data['current_locale']['language'] == $language) {
                    $data['current_locale']['image'] = $image;
                }
                $data['locales'][] = [
                    'language' => $language,
                    'image' => $image,
                    'locale' => $locale
                ];
            }
            return $this->sendResponse($data, '');
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }
    }

    public function setLocale(Request $request, $locale)
    {
        try {
            if ($locale) {
                $request->session()->put('_locale', $locale);
            } else {
                $request->session()->remove('_locale');
            }
            return $this->sendResponse([], '');
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }
    }
}