const mapStyleJson = [
    {
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#f5f5f5"
            }
        ]
    },
    {
        "elementType": "labels.icon",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    },
    {
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#616161"
            }
        ]
    },
    {
        "elementType": "labels.text.stroke",
        "stylers": [
            {
                "color": "#f5f5f5"
            }
        ]
    },
    {
        "featureType": "administrative.land_parcel",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#bdbdbd"
            }
        ]
    },
    {
        "featureType": "poi",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#eeeeee"
            }
        ]
    },
    {
        "featureType": "poi",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#757575"
            }
        ]
    },
    {
        "featureType": "poi.park",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#e5e5e5"
            }
        ]
    },
    {
        "featureType": "poi.park",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#9e9e9e"
            }
        ]
    },
    {
        "featureType": "road",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#ffffff"
            }
        ]
    },
    {
        "featureType": "road.arterial",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#757575"
            }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#dadada"
            }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#616161"
            }
        ]
    },
    {
        "featureType": "road.local",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#9e9e9e"
            }
        ]
    },
    {
        "featureType": "transit.line",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#e5e5e5"
            }
        ]
    },
    {
        "featureType": "transit.station",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#eeeeee"
            }
        ]
    },
    {
        "featureType": "water",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#c9c9c9"
            }
        ]
    },
    {
        "featureType": "water",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#9e9e9e"
            }
        ]
    }
]

let map, geocoder, infoWin

function QueryString(URL) {
    let query_string = {};
    let usefulParam = URL.split("?")[1] || "";
    let query = usefulParam || "";
    let vars = query.split("&");

    vars.map((value) => {
        const pair = value.split("=");
        if (typeof query_string[pair[0]] === "undefined") {
            query_string[pair[0]] = decodeURIComponent(pair[1]);
            // If second entry with this name
        } else if (typeof query_string[pair[0]] === "string") {
            query_string[pair[0]] = [query_string[pair[0]], decodeURIComponent(pair[1])];
            // If third or later entry with this name
        } else {
            query_string[pair[0]].push(decodeURIComponent(pair[1]));
        }
    })
    return query_string;
}

function initMap() {
    const options = {
        zoom: 5,
        zoomControl: false,
        mapTypeControl: false,
        scaleControl: false,
        streetViewControl: true,
        rotateControl: false,
        fullscreenControl: false,
        streetViewControlOptions: {
            style: google.maps.ZoomControlStyle.SMALL,
            position: google.maps.ControlPosition.RIGHT_TOP
        },
        mapTypeControlOptions: {
            mapTypeIds: ["styled_map"],
        },
    };
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), options);
    infoWin = new google.maps.InfoWindow();

    const mapStyle = new google.maps.StyledMapType(mapStyleJson)

    geocodeAddress(defaultCountry.name)

    map.mapTypes.set("styled_map", mapStyle);
    map.setMapTypeId("styled_map");

    if (typeof coordinate !== 'undefined') {
        createMarker(coordinate)
        map.setCenter(coordinate);
    } else {
        google.maps.event.addListener(map, 'idle', function (event) {
            if (map.center) {
                const lat = map.center.lat()
                const lng = map.center.lng()

                crudAjax({lat, lng}, '/api/classified/get-by-coordinates', 'GET', () => {}, true)
                    .then(res => {
                        if (res.success) {
                            const classifieds = res.classifieds
                            classifieds.map((value) => {
                                const coordinate = value.map_Val.split(',')
                                createMarker({lat: Number(coordinate[0]), lng: Number(coordinate[1])}, value)
                            })
                        } else {
                            alert(res.msg)
                        }
                    })
            }
        });

        $.ajax({
            async: false,
            type: 'GET',
            url: mapJsonUrl,
            data: QueryString(window.location.href),
            success: function (data) {
                data.map((value, key) => {
                    if(value.map_Val) {
                        const coordinate = value.map_Val.split(',')
                        createMarker({lat: Number(coordinate[0]), lng: Number(coordinate[1])}, value)
                        map.setCenter({lat: Number(coordinate[0]), lng: Number(coordinate[1])});
                    }
                })
            }
        })
    }
}

function geocodeAddress(address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            map.setCenter(results[0].geometry.location);
            map.fitBounds(results[0].geometry.viewport)
        }
    });
}

function createMarker(latLng, classified) {
    const marker = new google.maps.Marker({
        map,
        position: latLng,
        icon: mapPin
    });
    google.maps.event.addListener(marker, 'click', function () {
        infoWin.setContent(`
            <div id="content" class="col-md-12 p-0 m-0">
                <div id="bodyContent">
                    <div class="cover">
                        <a href="${classified.detail_url}">
                            <img class="map_image w-100" src="${classified.cover_photo}" height="auto" alt="${classified.name}'s cover photo"/>
                            <h6 class="map_subject text-truncate text-white w-100 px-3">${classified.name}</h6>
                        </a>
                    </div>
                   <div class="content">
                       <a href="${classified.detail_url}" class="text-dark">
                            ${classified.advs_desc}
                        </a>
                    </div>
                </div>
            </div>
        `);
        infoWin.open(map, marker);
    });
}

$('#locationInputWrapper').submit(function (e) {
    e.preventDefault()

    const location = $('#searchLocationInput').val()
    if (location) {
        geocodeAddress(location);
    }
})

// Dynamic placeholder
var SuperPlaceholder = function(options) {
    this.options = options;
    this.element = options.element
    this.placeholderIdx = 0;
    this.charIdx = 0;


    this.setPlaceholder = function() {
        placeholder = options.placeholders[this.placeholderIdx];
        var placeholderChunk = placeholder.substring(0, this.charIdx+1);
        document.querySelector(this.element).setAttribute("placeholder", this.options.preText + " " + placeholderChunk)
    };

    this.onTickReverse = function(afterReverse) {
        if (this.charIdx === 0) {
            afterReverse.bind(this)();
            clearInterval(this.intervalId);
            this.init();
        } else {
            this.setPlaceholder();
            this.charIdx--;
        }
    };

    this.goReverse = function() {
        clearInterval(this.intervalId);
        this.intervalId = setInterval(this.onTickReverse.bind(this, function() {
            this.charIdx = 0;
            this.placeholderIdx++;
            if (this.placeholderIdx === options.placeholders.length) {
                // end of all placeholders reached
                this.placeholderIdx = 0;
            }
        }), this.options.speed)
    };

    this.onTick = function() {
        var placeholder = options.placeholders[this.placeholderIdx];
        if (this.charIdx === placeholder.length) {
            // end of a placeholder sentence reached
            setTimeout(this.goReverse.bind(this), this.options.stay);
        }

        this.setPlaceholder();

        this.charIdx++;
    }

    this.init = function() {
        this.intervalId = setInterval(this.onTick.bind(this), this.options.speed);
    }

    this.kill = function() {
        clearInterval(this.intervalId);
    }
}

if (typeof mapPlaceholder !== 'undefined' && mapPlaceholder.length) {
    window.onload = function() {
        var sp = new SuperPlaceholder({
            placeholders: mapPlaceholder,
            preText: "",
            stay: 250,
            speed: 100,
            element: '#searchLocationInput'
        });
        sp.init();
    }
}
