<?php namespace Visiosoft\Emlak24Theme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\Emlak24Theme\Command\GetMapPin;
use Visiosoft\Emlak24Theme\Command\GetTrans;

class Emlak24ThemePlugin extends Plugin
{
    protected $advRepository;

    public function __construct(
        AdvRepositoryInterface $advRepository
    )
    {
        $this->advRepository = $advRepository;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getLatestAdsWithoutProjects',
                function ($keyword, $value) {
                    return $this->advRepository->latestAdsWithout($keyword, $value);
                }
            ),
            new \Twig_SimpleFunction(
              'getProjects',
              function ($cat_id) {
                  return $this->advRepository->getByCat($cat_id, 1, 4);
              }
            ),
            new \Twig_SimpleFunction(
                'e24_get_map_pin',
                function () {
                    return $this->dispatch(new GetMapPin());
                }
            ),
            new \Twig_SimpleFunction(
                'e24_get_trans',
                function () {
                    return $this->dispatch(new GetTrans());
                }
            ),
        ];
    }
}
