<?php namespace Visiosoft\Emlak24Theme\Command;

use Anomaly\FilesModule\File\Command\GetFile;
use Anomaly\Streams\Platform\Support\Decorator;
use Illuminate\Foundation\Bus\DispatchesJobs;

class GetMapPin
{
    use DispatchesJobs;

    public function handle()
    {
        if (!$mapPin = setting_value('visiosoft.theme.emlak24::map_pin')) {
            return null;
        }

        if (!$mapPin = (new Decorator())->decorate($this->dispatch(new GetFile($mapPin)))) {
            return null;
        }

        return $mapPin->make()->url();
    }
}
