let map, geocoder

function initMap() {
    const options = {
        zoom: 15,
    };
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), options);
    geocodeAddress(defaultCountry.name)

    google.maps.event.addListener(map, 'idle', function (event) {
        if (map.center) {
            const lat = map.center.lat()
            const lng = map.center.lng()

            crudAjax({lat, lng}, '/api/classified/get-by-coordinates', 'GET', () => {}, true)
                .then(res => {
                    if (res.success) {
                        const classifieds = res.classifieds

                        for (let i = 0; i < classifieds.length; i++) {
                            const classified = classifieds[i]

                            const coordinate = classified.map_Val.split(',')

                            const lat = coordinate[0]
                            const lng = coordinate[1]

                            createMarker({lat: Number(lat), lng: Number(lng)}, classified.detail_url)
                        }
                    } else {
                        alert(res.msg)
                    }
                })
        }
    });
}

function geocodeAddress(address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            map.setCenter(results[0].geometry.location);
            map.fitBounds(results[0].geometry.viewport)
        }
    });
}

function createMarker(latLng, detailURL) {
    const marker = new google.maps.Marker({
        map,
        position: latLng,
        icon: mapPin
    });
    google.maps.event.addListener(marker, 'click', function() {
        window.location.href = detailURL;
    });
}

$('#locationInputWrapper').submit(function (e) {
    e.preventDefault()

    const location = $('#searchLocationInput').val()
    if (location) {
        geocodeAddress(location);
    }
})
