<?php namespace Visiosoft\Emlak24Theme\Seed;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;

class RecommendedClassifiedsSeed extends Seeder
{

    private $areaRepository;
    private $blocksTypeRepository;
    private $fieldRepository;
    private $assignmentRepository;
    private $streamRepository;
    private $blockRepository;

    public function __construct(
        AreaRepositoryInterface $areaRepository,
        TypeRepositoryInterface $blocksTypeRepository,
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository,
        BlockRepositoryInterface $blockRepository
    ) {
        $this->areaRepository = $areaRepository;
        $this->blocksTypeRepository = $blocksTypeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
        $this->blockRepository = $blockRepository;
    }

    public function run()
    {
        if ($stream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages')) {
            // Create recommended classifieds field
            $recommendedClassifiedsField = [
                'name' => trans('visiosoft.theme.emlak24::field.recommended_classifieds'),
                'namespace' => 'pages',
                'slug' => 'recommended_classifieds',
                'type' => 'anomaly.field_type.multiple',
                'config' => [
                    'related' => AdvModel::class,
                    'max' => 10,
                    'mode' => 'lookup'
                ],
            ];

            if (!$field = $this->fieldRepository->findBySlugAndNamespace($recommendedClassifiedsField['slug'], $recommendedClassifiedsField['namespace'])) {
                $field = $this->fieldRepository->create([
                    'name' => $recommendedClassifiedsField['name'],
                    'namespace' => $recommendedClassifiedsField['namespace'],
                    'slug' => $recommendedClassifiedsField['slug'],
                    'type' => $recommendedClassifiedsField['type'],
                    'config' => $recommendedClassifiedsField['config'],
                    'locked' => 0
                ]);
            }

            if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->id,
                    'label' => $recommendedClassifiedsField['name'],
                ]);
            }
        }
    }
}
