let map, geocoder, infoWin

function initMap() {
    const options = {
        zoom: 15,
    };
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), options);
    infoWin = new google.maps.InfoWindow();

    geocodeAddress(defaultCountry.name)

    google.maps.event.addListener(map, 'idle', function (event) {
        if (map.center) {
            const lat = map.center.lat()
            const lng = map.center.lng()

            crudAjax({lat, lng}, '/api/classified/get-by-coordinates', 'GET', () => {}, true)
                .then(res => {
                    if (res.success) {
                        const classifieds = res.classifieds

                        for (let i = 0; i < classifieds.length; i++) {
                            const classified = classifieds[i]

                            const coordinate = classified.map_Val.split(',')

                            const lat = coordinate[0]
                            const lng = coordinate[1]

                            createMarker({lat: Number(lat), lng: Number(lng)}, classified)
                        }
                    } else {
                        alert(res.msg)
                    }
                })
        }
    });
}

function geocodeAddress(address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            map.setCenter(results[0].geometry.location);
            map.fitBounds(results[0].geometry.viewport)
        }
    });
}

function createMarker(latLng, classified) {
    const marker = new google.maps.Marker({
        map,
        position: latLng,
        icon: mapPin
    });
    google.maps.event.addListener(marker, 'click', function () {
        infoWin.setContent(`
            <div id="content" class="col-md-12 p-0 m-0">
                <div class="map_info_top"></div>
                <div id="bodyContent">
                    <p>
                        <img class="map_image w-100" src="${classified.cover_photo}" height="auto"/>
                    </p>
                    <h6 class="map_subject text-truncate text-primary">${classified.name}</h6>
                    <p class="map_price">${classified.price + ' ' + classified.currency}</p>
                    <p>
                        <a href="${classified.detail_url}" class="btn btn-info w-100" target="_blank">
                            <small>${showDetailsTrans}</small>
                        </a>
                    </p>
                </div>
            </div>
        `);
        infoWin.open(map, marker);
        infoWin.setStyle('map_subject')
    });
}

$('#locationInputWrapper').submit(function (e) {
    e.preventDefault()

    const location = $('#searchLocationInput').val()
    if (location) {
        geocodeAddress(location);
    }
})
