<?php namespace Visiosoft\Emlak24Theme;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Visiosoft\Emlak24Theme\Seed\MiddleSectionSeed;
use Visiosoft\Emlak24Theme\Seed\RecommendedClassifiedsSeed;
use Visiosoft\Emlak24Theme\Seed\ShowcaseCategoriesSeed;

class Emlak24ThemeSeeder extends Seeder
{
	/**
     * Run the seeder.
     */
    public function run()
    {
        // Middle Section Block Seeder
        $this->call(MiddleSectionSeed::class);

        // Showcase Categories Seeder
        $this->call(ShowcaseCategoriesSeed::class);

        // Recommended Classifieds Seeder
        $this->call(RecommendedClassifiedsSeed::class);

	    Model::unguard();
        DB::unprepared(file_get_contents(realpath(dirname(__DIR__)) . '/src/MailTemplates/templates.sql'));
        Model::reguard();
    }
}
