<?php

return [
    'logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    "favicon" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
        ]
    ],
    'bg_image' => [
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ['images']
        ],
    ],
    "show_blog_nav" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
            "mode"          => "checkbox",
        ]
    ],
    "navbar_phone_number" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "type"          => "tel",
            "default_value" => "+49 162 95 74068",
        ]
    ],
    "main_title_bold" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => 'visiosoft.theme.emlak24::field.get_offers_from_best_agents',
        ]
    ],
    "main_title_normal" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => 'visiosoft.theme.emlak24::field.get_best_options_for_you_in_24_hours',
        ]
    ],
    "sub_title" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => 'visiosoft.theme.emlak24::field.what_are_you_looking_for',
        ]
    ],
    "location_title" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => 'visiosoft.theme.emlak24::field.where_are_you_looking',
        ]
    ],
    "price_title" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => 'visiosoft.theme.emlak24::field.price_range',
        ]
    ],
    "contact_info_title" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => 'visiosoft.theme.emlak24::field.fill_your_info',
        ]
    ],
    "hide_main_content" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode"          => "checkbox",
            'default_value' => false,
        ]
    ],
    "replace_price" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode"          => "checkbox",
            'default_value' => false,
        ]
    ],
    "simple_nav" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode"          => "checkbox",
            'default_value' => false,
        ]
    ],
    "showcase_ads_count" => [
        "type"   => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 5,
        ]
    ],
    "consultants_limit" => [
        "type"   => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 9,
        ]
    ],
    "navigationColor" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => "#343A40",
        ]
    ],
    "footerColor" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => "#343a40",
        ]
    ],
    "price_step_slugs" => [
        "type"   => "anomaly.field_type.tags",
        "config" => [
            "default_value" => ['buy', 'sell'],
        ]
    ],
	'intro_page' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		]
	],
	'change_intro_page' => [
		'type' => 'anomaly.field_type.relationship',
		'config' => [
			'related' => \Anomaly\PagesModule\Page\PageModel::class,
		]
	],
	'default_button_url' => [
		'type' => 'anomaly.field_type.url',
		'config' => [
			'default_value' => '?main=true'
		]
	],
	'slider_video_url' => [
		'type' => 'anomaly.field_type.url',
		'config' => [
			'default_value' => '#'
		]
	],
	'analyst_bar' => [
		'type' => 'anomaly.field_type.slider',
		'config' => [
			'default_value' => 25,
			'step' => 1,
			'min' => 0,
			'max' => 100,
		]
	],
	'marketing_bar' => [
		'type' => 'anomaly.field_type.slider',
		'config' => [
			'default_value' => 25,
			'step' => 1,
			'min' => 0,
			'max' => 100,
		]
	],
	'social_media_bar' => [
		'type' => 'anomaly.field_type.slider',
		'config' => [
			'default_value' => 25,
			'step' => 1,
			'min' => 0,
			'max' => 100,
		]
	],
	'info_pages' => [
		'type' => 'anomaly.field_type.relationship',
		'config' => [
			'mode' => 'lookup',
			'related' => \Anomaly\PagesModule\Page\PageModel::class,
		]
	],
	'footer_description' => 'anomaly.field_type.text',
	'facebook' => 'anomaly.field_type.url',
	'twitter' => 'anomaly.field_type.url',
	'instagram' => 'anomaly.field_type.url',
	'linkedin' => 'anomaly.field_type.url',
];
