<?php

return [
    'logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    'logo_white' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    "favicon" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
        ]
    ],
    "show_blog_nav" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
            "mode"          => "checkbox",
        ]
    ],
    "navbar_phone_number" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "type"          => "tel",
            "default_value" => "+49 162 95 74068",
        ]
    ],
    "showcase_ads_count" => [
        "type"   => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 5,
        ]
    ],
    "consultants_limit" => [
        "type"   => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 9,
        ]
    ],
    "navigationColor" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => "#343A40",
        ]
    ],
    "footerColor" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => "#343a40",
        ]
    ],
    "price_step_slugs" => [
        "type"   => "anomaly.field_type.tags",
        "config" => [
            "default_value" => ['buy', 'sell'],
        ]
    ],
    "select_project_category" => [
        "type" => "anomaly.field_type.select",
        "config" => [
            "options" => function(\Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->getMainCategories()->pluck('name', 'id')->all();
            },
        ],
    ],
    'map_pin' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
        ]
    ],
    "map_placeholder" => [
        "type"   => "anomaly.field_type.tags",
        "config" => [
            'default_value' => [
                'Istanbul',
                'Ankara',
                'Izmir',
            ]
        ]
    ],
    "cyprus" => [
        "type"   => "anomaly.field_type.relationship",
        "config" => [
            "related" => \Visiosoft\LocationModule\City\CityModel::class,
            "mode"    => "lookup",
        ]
    ],
    "discounted_shipping_service_url" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => '#',
        ]
    ],
    "free_tcip_policy_url" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => '#',
        ]
    ],
    "discounted_furniture_url" => [
        "type"   => "anomaly.field_type.text",
        "config" => [
            "default_value" => '#',
        ]
    ],
    'show_home_popup' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'popup_content' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],

];
