<?php namespace Visiosoft\DopingsModule\Doping\Command;

use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class getAdsByCatAndDopingType
{

    private $category;
    private $type;

    public function __construct($category, $type)
    {
        $this->category = $category;
        $this->type = $type;
    }

    public function handle(
        CategoryRepositoryInterface $categoryRepository,
        TypeRepositoryInterface $typeRepository,
        DopingRepositoryInterface $dopingRepository
    )
    {
        $category = is_numeric($this->category) ? $categoryRepository->find($this->category) : $categoryRepository->findBySlug($this->category);
        $dopingType = is_numeric($this->type) ? $typeRepository->find($this->type) :  $typeRepository->findBySlug($this->type)->first();

        if (!$category || !$dopingType) {
            return ['ads' => null];
        } else {
            $ads = $dopingRepository->getAdsByCatAndDopingType($category->id, $dopingType->id);

            return [
                'ads' => $ads,
                'category' => $category,
            ];
        }
    }
}
