<?php namespace Visiosoft\DopingsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\DopingsModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\DopingsModule\Package\PackageRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsPackageEntryModel;
use Visiosoft\DopingsModule\Package\PackageModel;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DopingsModule\Type\TypeRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Visiosoft\DopingsModule\Type\TypeModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Visiosoft\DopingsModule\Doping\DopingModel;

class DopingsModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        DopingsModulePlugin::class,
    ];

    protected $routes = [
        'admin/dopings/package'           => 'Visiosoft\DopingsModule\Http\Controller\Admin\PackageController@index',
        'admin/dopings/package/create'    => 'Visiosoft\DopingsModule\Http\Controller\Admin\PackageController@create',
        'admin/dopings/package/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\PackageController@edit',
        'admin/dopings/types' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@index',
        'admin/dopings/types/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@create',
        'admin/dopings/types/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@edit',
        'admin/dopings' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@index',
        'admin/dopings/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@create',
        'admin/dopings/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@edit',

        'admin/dopings-advs/choose/{ad_id}' => [
            'as' => 'visiosoft.module.dopings::dopings_advs_choose',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@choose',
        ],
        'admin/dopings-advs/bulk-choose' => [
            'as' => 'visiosoft.module.dopings::dopings_advs_bulk_choose',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@bulkChoose'
        ],
        'admin/dopings-advs/bulk-choose/handle/{type_id}' => [
            'as' => 'visiosoft.module.dopings::dopings_advs_bulk_choose_handle',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@bulkHandle'
        ],

        'doping/{id}' => [
            'as' => 'add_doping',
            'middleware' => ['auth'],
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@addDoping',
        ],
        'dopings/buy' => [
            'middleware' => ['auth'],
            'as' => 'doping::buy',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@buy',
        ],
        'my-dopings' => [
            'middleware' => ['auth'],
            'as' => 'visiosoft.module.dopings::my_dopings',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@myDopings'
        ],
        'admin/doping/approve/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@approve',
        'admin/doping/revert/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@revert',
        'showcase' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@showcase',

        'admin/doping/query-ads' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@queryAds',
        'admin/doping/types/{id}/{type}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@actions',

    ];

    protected $listeners = [
        'Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying' => [
            'Visiosoft\DopingsModule\Listeners\AddDopingsButton',
        ],
    ];

    protected $bindings = [
        DopingsPackageEntryModel::class => PackageModel::class,
        DopingsTypesEntryModel::class => TypeModel::class,
        DopingsDopingsEntryModel::class => DopingModel::class,
    ];

    protected $singletons = [
        PackageRepositoryInterface::class => PackageRepository::class,
        TypeRepositoryInterface::class => TypeRepository::class,
        DopingRepositoryInterface::class => DopingRepository::class,
    ];
}
