<?php namespace Visiosoft\DopingsModule\Doping\Command;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\DopingsModule\Type\TypeRepository;

class getFeaturesBySlugs
{
    protected $slugs;

    public function __construct($slugs = [])
    {
        $this->slugs = $slugs;
    }

    public function handle(TypeRepository $dopingRepository, DopingModel $model, AdvModel $advModel)
    {
        $dopingIds = $dopingRepository->findByAllSlug($this->slugs)->getQueueableIds();

        return $model->getFeaturesWithDopingsAndAds($dopingIds);
    }
}
