<?php namespace Visiosoft\DopingsModule\Doping\Form;


use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class DopingFormHandler
{


    public function handle(
        DopingFormBuilder $builder,
        DopingRepositoryInterface $repository,
        TypeRepositoryInterface $type
    )
    {
        if (!$builder->canSave()) {
            return;
        }

        $posts = $builder->getPostData();

        foreach ($posts['adv'] as $ad) {
            foreach ($posts['dopings'] as $doping) {

                $type = $type->find($doping);

                if (!is_null($type)) {

                    $now = Carbon::now();

                    $repository->create([
                        'name' => $type->name,
                        'adv_name_id' => $ad,
                        'doping_type_id' => $type->id,
                        'price' => $type->price,
                        'currency' => setting_value('streams::currency'),
                        'user_id' => Auth::id(),
                        'status' => $posts['status'],
                        'expiry_date' => $now->addDays($type->duration),
                    ]);
                }
            }
        }
    }
}
