<?php namespace Visiosoft\DopingsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Facades\DB;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class DopingsModuleSeeder extends Seeder
{
    public function run()
    {
        $typeRepository = app(TypeRepositoryInterface::class);
        DB::table('dopings_types')->truncate();
        DB::table('dopings_types_translations')->truncate();
        DB::table('dopings_dopings')->truncate();
        $typeRepository->create([
            'en' => [
                'name' => 'Home Page Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'tr' => [
                'name' => 'Ana Sayfa Vitrin',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'slug' => 'home_page_showcase',
            'price' => 100,
            'duration' => 30,
            'icon' => 'home'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Top Category Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name' => 'Ust Kategori Vitrin',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'slug' => 'top_category_showcase',
            'price' => 200,
            'duration' => 15,
            'icon' => 'list-ol'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Category Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name' => 'Kategori Vitrini',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'slug' => 'category_showcase',
            'price' => 300,
            'duration' => 7,
            'icon' => 'list'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Featured Ad',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name' => 'Farkliyim',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'slug' => 'featured_ad',
            'price' => 350,
            'duration' => 5,
            'icon' => 'heart'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Fire Sale',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde acil acil kateogrisinde yer alsın istiyorsanız hemen alın'
            ],
            'tr' => [
                'name' => 'Acil Acil',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde acil acil kateogrisinde yer alsın istiyorsanız hemen alın'
            ],
            'slug' => 'fire_sale',
            'price' => 150,
            'duration' => 6,
            'icon' => 'bolt'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Update Date',
                'description' => 'If you want your ad to be the most up-to-date on our site, which is visited by thousands of people every day, buy it now!'
            ],
            'tr' => [
                'name' => 'Güncelim',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde en güncel olarak yer alsın istiyorsanız hemen alın!'
            ],
            'slug' => 'updated',
            'price' => 150,
            'duration' => null,
            'icon' => 'clock'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Decreasing Prices',
                'description' => 'Let your ad be in the category of decreasing prices on our site, which is visited by thousands of people every day.'
            ],
            'tr' => [
                'name' => 'Fiyatı Düşenler',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde fiyatı düşenler kategorisinde yer alsın.'
            ],
            'slug' => 'decreasing_prices',
            'price' => 150,
            'duration' => null,
            'icon' => 'arrow-circle-down'
        ]);

        $typeRepository->create([
            'en' => [
                'name' => 'Opportunity Products',
                'description' => 'Your product will appear in the Deal of the Day field on the homepage.'
            ],
            'tr' => [
                'name' => 'Fırsat Ürünü',
                'description' => 'Ürününüz anasayfada bulunana Günün Fırsatı alanında görünecektir.'
            ],
            'slug' => 'opportunity_products',
            'price' => 150,
            'duration' => null,
            'icon' => 'calendar'
        ]);
    }
}