<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\DopingsModule\Package\PackageModel;
use Visiosoft\DopingsModule\Type\TypeModel;

class VisiosoftModuleDopingsCreatePackageFields extends Migration
{
    protected $fields = [
        'category' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'search',
                'related' => CategoryModel::class,
            ],
        ],
        'package' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'search',
                'related' => PackageModel::class,
            ],
        ],
        'interval' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                "min" => 1,
                "max" => 30,
            ],
        ],
        'interval_period' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                "options" =>
                    [
                        "day" => "visiosoft.module.dopings::field.day.name",
                        "week" => "visiosoft.module.dopings::field.week.name",
                        "month" => "visiosoft.module.dopings::field.month.name"
                    ],
            ],
        ],
        'type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'mode' => 'lookup',
                'related' => TypeModel::class,
            ],
        ],
    ];
}
