<?php namespace Visiosoft\DopingsModule\Doping;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Carbon\Carbon;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class DopingRepository extends EntryRepository implements DopingRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var DopingModel
     */
    protected $model;

    /**
     * @var TypeRepositoryInterface
     */
    private $typeRepository;

    /**
     * @var AdvRepositoryInterface
     */
    private $advRepository;

    /**
     * Create a new DopingRepository instance.
     *
     * @param DopingModel $model
     * @param TypeRepositoryInterface $typeRepository
     */
    public function __construct(
        DopingModel $model,
        TypeRepositoryInterface $typeRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        $this->model = $model;
        $this->typeRepository = $typeRepository;
        $this->advRepository = $advRepository;
    }

    public function getAdsDopings($adId)
    {
        $typesIds = $this->newQuery()
            ->where('status', 'approved')
            ->where('adv_name_id', $adId)
            ->where('expiry_date', '>=', Carbon::now())
            ->pluck('doping_type_id');

        return $this->typeRepository->newQuery()
            ->whereNotIn('dopings_types.id', $typesIds)
            ->get();
    }

    public function getAdsActiveDopings($adId)
    {
        return $this->newQuery()
            ->where('status', 'approved')
            ->where('adv_name_id', $adId)
            ->where('expiry_date', '>=', Carbon::now())
            ->get();
    }

    public function getUserDopings($userId = null)
    {
        $userId = $userId ?: auth()->id();

        return $this
            ->newQuery()
            ->where('user_id', $userId)
            ->whereIn('status', ['pending_approve', 'approved'])
            ->get();
    }

    public function getAdsByCatAndDopingType($catId, $typeId)
    {
        $ads = $this->advRepository->newQuery()
            ->join('dopings_dopings as dopings', 'advs_advs.id', '=', 'dopings.adv_name_id')
            ->select('advs_advs.*', 'dopings.adv_name_id as adv_id')
            ->where('cat1', $catId)
            ->where('doping_type_id', $typeId)
            ->groupBy('adv_id')
            ->inRandomOrder()
            ->get();

        $ads = $this->advRepository->getModel()->getLocationNames($ads);

        foreach ($ads as $index => $ad) {
            $ads[$index]->detail_url = $this->advRepository->getModel()->getAdvDetailLinkByModel($ad, 'list');
            $ads[$index] = $this->advRepository->getModel()->AddAdsDefaultCoverImage($ad);
        }

        return $ads;
    }
}
