<?php namespace Visiosoft\DopingsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\DopingsModule\Http\Controller\Admin\PendingDopingsController;
use Visiosoft\DopingsModule\PendingDoping\PendingDopingModel;

class DopingsController extends PublicController {

    public function addDoping($id, DopingRepositoryInterface $repository) {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $dopings = $repository->getDopingAds($id);

        if (count($dopings) == 0 ) {
            return redirect(route('adv_detail', $id))->with('success', [trans('visiosoft.module.advs::field.all_dopings_added')]);
        }

        return $this->view->make('visiosoft.module.dopings::buy', compact('id', 'dopings'));
    }

    public function save(Request $request, DopingRepositoryInterface $repository)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        if(isset($request->request->all()['action']) == "save")
        {
            $new_doping = $request->request->all();
            unset($new_doping['action'],$new_doping['_token']);
            $new_doping['user_id'] = auth()->user()->id;

            foreach ($request->doping as $doping) {
                $doping_type = $repository->getDopingTypes($doping);
                $doping = new DopingsDopingsEntryModel();
                $doping->price = $doping_type->price;
                $doping->expiry_date = null;
                $doping->name = $doping_type->name;
                $doping->adv_name = $request->adv_name;
                $doping->doping_type = $doping_type->id;
                $doping->user = auth()->user()->id;
                $doping->status = "in_cart";
                $doping->save();

                $cart = $this->dispatch(new GetCart());

                $cart->add($doping, 1);
            }

            return redirect('cart');
        }
    }
}
