<?php namespace Visiosoft\DopingsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\DopingsModule\Http\Middleware\dopingRole;
use Visiosoft\DopingsModule\Package\Contract\PackageRepositoryInterface;
use Visiosoft\DopingsModule\Package\PackageRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsPackageEntryModel;
use Visiosoft\DopingsModule\Package\PackageModel;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DopingsModule\Type\TypeRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Visiosoft\DopingsModule\Type\TypeModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingRepository;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Illuminate\Routing\Router;

class DopingsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        DopingsModulePlugin::class,
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/dopings/package'           => 'Visiosoft\DopingsModule\Http\Controller\Admin\PackageController@index',
        'admin/dopings/package/create'    => 'Visiosoft\DopingsModule\Http\Controller\Admin\PackageController@create',
        'admin/dopings/package/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\PackageController@edit',
        'admin/dopings/types' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@index',
        'admin/dopings/types/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@create',
        'admin/dopings/types/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\TypesController@edit',
        'admin/dopings' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@index',
        'admin/dopings/create' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@create',
        'admin/dopings/edit/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@edit',

        'admin/dopings-advs/choose/{ad_id}' => [
            'as' => 'visiosoft.module.dopings::dopings_advs_choose',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@choose',
        ],
        'admin/dopings-advs/bulk-choose' => [
            'as' => 'visiosoft.module.dopings::dopings_advs_bulk_choose',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@bulkChoose'
        ],
        'admin/dopings-advs/bulk-choose/handle/{type_id}' => [
            'as' => 'visiosoft.module.dopings::dopings_advs_bulk_choose_handle',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@bulkHandle'
        ],

        'doping/{id}' => [
            'as' => 'add_doping',
            'middleware' => [
                dopingRole::class
            ],
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@addDoping',
        ],
        'dopings/buy' => [
            'middleware' => [
                dopingRole::class
            ],
            'as' => 'doping::buy',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@buy',
        ],
        'my-dopings' => [
            'middleware' => [
                'auth',
                dopingRole::class
            ],
            'as' => 'visiosoft.module.dopings::my_dopings',
            'uses' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@myDopings'
        ],
        'admin/doping/approve/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@approve',
        'admin/doping/revert/{id}' => 'Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController@revert',
        'showcase' => 'Visiosoft\DopingsModule\Http\Controller\DopingsController@showcase',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\DopingsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\DopingsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        'Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying' => [
            'Visiosoft\DopingsModule\Listeners\AddDopingsButton',
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\DopingsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        DopingsPackageEntryModel::class => PackageModel::class,
        DopingsTypesEntryModel::class => TypeModel::class,
        DopingsDopingsEntryModel::class => DopingModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PackageRepositoryInterface::class => PackageRepository::class,
        TypeRepositoryInterface::class => TypeRepository::class,
        DopingRepositoryInterface::class => DopingRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
