<?php namespace Visiosoft\DopingsModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Anomaly\Streams\Platform\Model\Dopings\DopingsTypesEntryModel;
use Carbon\Carbon;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\Form\DopingFormBuilder;
use Visiosoft\DopingsModule\Doping\Table\DopingTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DopingsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param DopingTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(DopingTableBuilder $table)
    {
        $table->setColumns([
            'name',
            'adv_name' => [
                'value' => function (EntryModel $entry, AdvModel $advModel) {
                    $isAd = $advModel->getAdv($entry->adv_name_id, false, true);
                    if (!is_null($isAd)) {
                        $url = $advModel->getAdvDetailLinkByModel($isAd, 'list');
                        if ($isAd->deleted_at) {
                            return '<a class="font-weight-bold" href="#" >' . $isAd->name . "<a>";
                        }
                        return '<a class="font-weight-bold" href="' . $url . '" >' . $isAd->name . "<a>";
                    }
                    return "<font color='red'>" . trans('visiosoft.module.dopings::field.deleted_ad') . " [id=" . $entry->adv_name_id . "]</font>";
                }
            ],
        ]);
        $table->addButtons([
            'status' => [
                'text' => function (EntryInterface $entry) {
                    if ($entry->status == 'approved') {
                        return "visiosoft.module.dopings::button.revert";
                    } else {
                        return "visiosoft.module.dopings::button.approve";
                    }
                },
                'href' => function (EntryInterface $entry) {
                    if ($entry->status == 'approved') {
                        return "/admin/doping/revert/{entry.id}";
                    } else {
                        return "/admin/doping/approve/{entry.id}";
                    }
                },
                'type' => function (EntryInterface $entry) {
                    if ($entry->status == 'approved') {
                        return "danger";
                    } else {
                        return "success";
                    }
                },
            ],
            'edit'
        ]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param DopingFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(DopingFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param DopingFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(DopingFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve($id)
    {
        $now = Carbon::now();
        $doping = DopingsDopingsEntryModel::find($id);
        $doping_duration = DopingsTypesEntryModel::find($doping->doping_type_id);
        $doping->status = 'approved';
        $doping->expiry_date = $now->addDays($doping_duration->duration);
        $doping->save();
        return back();
    }


    public function revert($id)
    {
        $doping = DopingsDopingsEntryModel::find($id);
        $doping->status = 'pending_approve';
        $doping->expiry_date = null;
        $doping->save();
        return back();
    }
}
