<?php namespace Visiosoft\DopingsModule;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Facades\DB;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class DopingsModuleSeeder extends Seeder
{
    public function run(TypeRepositoryInterface $typeRepository)
    {
        DB::table('dopings_types')->truncate();
        DB::table('dopings_types_translations')->truncate();
        DB::table('dopings_dopings')->truncate();
        DB::table('dopings_dopings_translations')->truncate();
        $typeRepository->create([
            'en' => [
                'name' => 'Home Page Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
            ],
            'tr' => [
                'name'  => 'Ana Sayfa Vitrin',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 100,
            'duration' => 30,
            'icon' => 'heart'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Top Category Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Ust Kategori Vitrin',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 200,
            'duration' => 15,
            'icon' => 'globe'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Category Showcase',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Kategori Vitrini',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 300,
            'duration' => 7,
            'icon' => 'pencil-alt'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Featured Ad',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Farkliyim',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

            ],
            'price' => 350,
            'duration' => 5,
            'icon' => 'home'
        ]);
        $typeRepository->create([
            'en' => [
                'name' => 'Fire Sale',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde acil acil kateogrisinde yer alsın istiyorsanız hemen alın'

            ],
            'tr' => [
                'name'  => 'Acil Acil',
                'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde acil acil kateogrisinde yer alsın istiyorsanız hemen alın'
            ],
            'price' => 150,
            'duration' => 6,
            'icon' => 'exclamation-circle'
        ]);
    }
}