<?php namespace Visiosoft\DopingsModule\Doping\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Str;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\DopingsModule\Doping\Table\DopingTableBuilder;
use Visiosoft\DopingsModule\Package\Contract\PackageRepositoryInterface;

class RefreshExpireDateMultiple extends ActionHandler
{
    public function handle(DopingTableBuilder $builder, array $selected, PackageRepositoryInterface $packageRepository)
    {
        try {
            $model = $builder->getTableModel();
            $now = Carbon::now();
            $dopings = $model->newQuery()->whereIn('id', $selected)->where('expiry_date', '<', $now)->get();
            $count = $dopings->count();

            foreach ($dopings as $doping) {
                if ($package = $doping->package) {
                    $date = $now->add($package->interval, Str::lower($package->interval_period));
                } else {
                    $date = $now->addDays($doping->doping_type->duration);
                }
                $doping->update([
                    'expiry_date' => $date,
                ]);
            }
            $this->messages->success(trans('visiosoft.module.dopings::messages.refresh_expiry_success', compact('count')));
        } catch (Exception $e) {
            $log = new Logger('dopings_refresh_expire_date_multiple');
            $log->pushHandler(new StreamHandler(storage_path('logs/dopings_refresh_multi_expire_date.log')), Logger::ERROR);
            $log->error($e);
            $this->messages->error(trans('visiosoft.module.advs::message.error_general'));
        }
        return redirect()->back();
    }
}