<?php

namespace Visiosoft\DopingsModule\Type\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class TypeTableButtons
{
    public function handle(TypeTableBuilder $builder)
    {
        $buttons = [
            'edit',
            'status' => [
                'text' => function (EntryInterface $entry) {
                    $text_type = ($entry->getStatus() == 'approved') ? 'decline' : 'approve';
                    return "<font class='hidden-xs-down'>" . trans('visiosoft.module.advs::button.' . $text_type) . "</font>";

                },
                'icon' => function (EntryInterface $entry) {
                    return ($entry->getStatus() == 'approved') ? "fa fa-eye-slash" : "fa fa-eye";
                },
                'href' => function (EntryInterface $entry) {
                    $action_type = ($entry->getStatus() == 'approved') ? 'declined' : 'approved';
                    return "/admin/doping/types/{entry.id}/" . $action_type;
                },
                'type' => function (EntryInterface $entry) {
                    return ($entry->getStatus() == 'approved') ? "danger" : "success";
                },
            ],
        ];

        $builder->setButtons($buttons);

        return $buttons;
    }

}
