<?php namespace Visiosoft\DopingsModule\Type\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\DopingsModule\Type\Table\Handler\Approve;
use Visiosoft\DopingsModule\Type\Table\Handler\Decline;


class TypeTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'approve' => [
            'handler' => Approve::class,
            'class' => 'btn btn-success'
        ],
        'decline' => [
            'handler' => Decline::class,
            'class' => 'btn btn-danger'
        ],
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
