<?php namespace Visiosoft\DopingsModule\Package\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class PackageFormFields
{

    public function handle(PackageFormBuilder $builder)
    {
        $builder->setFields([
            'type',
            'category' => [
                "config" => [
                    "handler" => function (RelationshipFieldType $fieldType, CategoryRepositoryInterface $category) {
                        $categories = $category->getMainCategories()->pluck('name', 'id')->all();
                        $fieldType->setOptions($categories);
                    }
                ]
            ],
            'price',
            'interval',
            'interval_period',
        ]);
    }
}
