<?php namespace Visiosoft\DopingsModule\Doping\Form;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Anomaly\MultipleFieldType\MultipleFieldType;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Type\TypeModel;

class DopingFormFields
{

    public function handle(DopingFormBuilder $builder)
    {
        $builder->setFields([
            'adv' => [
                'type' => 'anomaly.field_type.multiple',
                'config' => [
                    "handler" => function (MultipleFieldType $fieldType, AdvModel $advModel) {

                        $advs = $advModel->newQuery()->leftJoin('advs_advs_translations', function ($join) {
                            $join->on('advs_advs.id', '=', 'advs_advs_translations.entry_id');
                            $join->whereIn('advs_advs_translations.locale', [config('app.locale'), setting_value('streams::default_locale'), 'en']);//active lang
                        });
                        $advs = $advs->where('advs_advs.slug', '!=', "")
                            ->select('advs_advs.*', 'advs_advs_translations.name as name')
                            ->get();


                        $fieldType->setOptions($advs->pluck('name', 'id')->all());
                    }
                ],
            ],
            'dopings' => [
                'type' => 'anomaly.field_type.checkboxes',
                'config' => [
                    "handler" => function (CheckboxesFieldType $fieldType, TypeModel $typeModel) {

                        $types = $typeModel->newQuery()->leftJoin('dopings_types_translations', function ($join) {
                            $join->on('dopings_types.id', '=', 'dopings_types_translations.entry_id');
                            $join->whereIn('dopings_types_translations.locale', [config('app.locale'), setting_value('streams::default_locale'), 'en']);//active lang
                        });
                        $types = $types->where('dopings_types.slug', '!=', "")
                            ->select('dopings_types.*', 'dopings_types_translations.name as name')
                            ->get();


                        $fieldType->setOptions($types->pluck('name', 'id')->all());
                    }
                ],
            ],
            'status' => [
                'type' => 'anomaly.field_type.select',
                'config' => [
                    "mode" => "buttons",
                    "options" => ['pending_approve' => 'visiosoft.module.dopings::field.status.option.pending_approve', 'approved' => 'visiosoft.module.dopings::field.status.option.approved'],
                    "separator" => ":",
                    "default_value" => 'approved',
                ],
            ],
        ]);
    }

}
