<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDopingsCreatePackageStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'package',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'type' => [
            'required' => true,
        ],
        'category',
        'price' => [
            'required' => true,
        ],
        'interval' => [
            'required' => true,
        ],
        'interval_period' => [
            'required' => true,
        ],
    ];

}
