<?php namespace Visiosoft\DopingsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Twig\TwigFunction;
use Visiosoft\DopingsModule\Doping\Command\getAdsByCatAndDopingType;
use Visiosoft\DopingsModule\Doping\Command\getFeatures;
use Visiosoft\DopingsModule\Doping\Command\getFeaturesBySlugs;

class DopingsModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getFeatures',
                function ($type) {
                    if (!$ads = $this->dispatch(new getFeatures($type))) {
                        return null;
                    }
                    return $ads;
                }
            ),
            new TwigFunction(
                'getAdsByCatAndDopingType',
                function ($category, $type) {
                    $ads = $this->dispatch(new getAdsByCatAndDopingType($category, $type));
                    return $ads['ads'] ? $ads : null;
                }
            ),
            new TwigFunction(
                'getFeaturesBySlugs',
                function ($slugs = []) {
                    return $this->dispatch(new getFeaturesBySlugs($slugs));
                }
            )
        ];
    }
}
