<?php namespace Visiosoft\DopingsModule\Doping\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\DopingsModule\Doping\Table\Filter\AdFilterQuery;
use Visiosoft\DopingsModule\Doping\Table\Filter\StatusFilterQuery;
use Visiosoft\DopingsModule\Doping\Table\Filter\UserFilterQuery;
use Visiosoft\DopingsModule\Doping\Table\Handler\Approve;
use Visiosoft\DopingsModule\Doping\Table\Handler\RefreshExpireDateMultiple;

class DopingTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'user' => [
            'exact' => true,
            'filter' => 'select',
            'query' => UserFilterQuery::class,
        ],
        'ad' => [
            'exact' => true,
            'filter' => 'select',
            'query' => AdFilterQuery::class,
        ],
        'status' => [
            'filter'  => 'select',
            'query'   => StatusFilterQuery::class,
            'options' => [
                'approved'   => 'visiosoft.module.dopings::field.status.option.approved',
                'pending_approve' => 'visiosoft.module.dopings::field.status.option.pending_approve',
            ],
        ]
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'name',
        'adv_name'
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete',
        'approve' => [
            'handler' => Approve::class,
            'class' => 'btn btn-success'
        ],
        'extend' => [
            'handler' => RefreshExpireDateMultiple::class,
            'text'    => 'visiosoft.module.dopings::button.refresh_expire_date',
            'type'    => 'info',
            'icon'    => 'fa fa-clock-o',
        ]

    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'status' => 'DESC',
        ],
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.advs::js/admin/filter-user.js',
            'visiosoft.module.dopings::js/admin/filters.js',
        ],
        'styles.css' => [
            'visiosoft.module.advs::css/admin/filter-user.css',
            'visiosoft.module.dopings::css/admin/filters.css',
        ],
    ];

}
