<?php namespace Visiosoft\DopingsModule\Listeners;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\Action;
use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Table\AdvTableBuilder;

class AddDopingsButton
{

    /**
     * @var UserRepositoryInterface
     */
    protected $userRepository;

    /**
     * AddViewAdsAction constructor.
     * @param UserRepositoryInterface $userRepository
     */
    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * @param TableIsQuerying $event
     */
    public function handle(TableIsQuerying $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == AdvTableBuilder::class) {
            $this->addDopingsButton($builder);
            $this->addDopingsAction($builder);
        }
    }

    /**
     * Add a button to add a doping.
     *
     * @param AdvTableBuilder $builder
     */
    protected function addDopingsButton(AdvTableBuilder $builder)
    {
        $buttons = $builder->getButtons();
        if (isset($buttons['settings'])) {
            $dropdown = array_merge($buttons['settings']['dropdown'], [
                "add_doping" => [
                    "data-toggle" => "modal",
                    "data-target" => "#modal",
                    "text" => trans('visiosoft.module.dopings::button.add_doping'),
                    "href" => "admin/dopings-advs/choose/{entry.id}",
                ]
            ]);
            $buttons['settings']['dropdown'] = $dropdown;
            $builder->setButtons($buttons);
        }
    }

    /**
     * Add an action to mass add dopings.
     *
     * @param AdvTableBuilder $builder
     */
    protected function addDopingsAction(AdvTableBuilder $builder)
    {
        $action = new Action();
        $action->setTag('a');
        $action->setType('info');
        $action->setIcon('plus');
        $action->setText(trans('visiosoft.module.dopings::button.add_doping'));
        $action->setSize('sm');
        $action->setSlug('add_doping');
        $action->setDisabled(true);
        $action->setAttributes([
            'data-toggle' => 'modal',
            'data-target' => '#modal',
            'href' => route('visiosoft.module.dopings::dopings_advs_bulk_choose'),
        ]);
        $builder->getTable()->addAction($action);
    }
}