<?php namespace Visiosoft\DopingsModule\Doping;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Carbon\Carbon;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingInterface;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;

class DopingModel extends DopingsDopingsEntryModel implements DopingInterface
{

    public function getFeaturedAdvs($type)
    {
        $dopings = DopingsDopingsEntryModel::query()
            ->where('doping_type_id', $type)
            ->where('status', 'approved')
            ->where('expiry_date', '>', Carbon::now())
            ->inRandomOrder()
            ->pluck('adv_name_id');
        $doping_advs = AdvModel::query()
            ->where('status', 'approved')
            ->whereIn('advs_advs.id', $dopings)
            ->inRandomOrder();

        return $doping_advs->paginate(setting_value('visiosoft.module.dopings::homePageLimit', setting_value('streams::per_page')));
    }

    public function getDoping()
    {
        return DopingModel::query();
    }

    public function isDoping($id)
    {
        return $this->getDoping()->where('dopings_dopings.id', $id)->first();
    }

    public function getFeaturedAds($type)
    {
        $dopings = DopingsDopingsEntryModel::query()
            ->where('doping_type_id', $type)
            ->where('status', 'approved')
            ->where('expiry_date', '>', Carbon::now())
            ->inRandomOrder()
            ->pluck('adv_name_id');
        return $doping_advs = AdvsAdvsEntryModel::query()
            ->whereIn('advs_advs.id', $dopings)
            ->inRandomOrder()
            ->pluck('id');
    }

    public function filterAdvs($type, $advs)
    {
        $ids = $this->getFeaturedAds($type);
        return $advs->whereIn('id', $ids);
    }

    public function reFilterAdvs($type, $advs)
    {
        $ids = $this->getFeaturedAds($type);
        return $advs->whereNotIn('id', $ids);
    }
}
