<?php namespace Visiosoft\DopingsModule\Doping\Command;

use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\DopingsModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class getAdsByCatAndDopingType
{

    private $catSlug;
    private $typeSlug;

    public function __construct($catSlug, $typeSlug)
    {
        $this->catSlug = $catSlug;
        $this->typeSlug = $typeSlug;
    }

    public function handle(
        CategoryRepositoryInterface $categoryRepository,
        TypeRepositoryInterface $typeRepository,
        DopingRepositoryInterface $dopingRepository
    )
    {
        $category = $categoryRepository->findBySlug($this->catSlug);
        $dopingType = $typeRepository->findBy('slug', $this->typeSlug);

        if (!$category || !$dopingType) {
            return ['ads' => null];
        } else {
            $ads = $dopingRepository->getAdsByCatAndDopingType($category->id, $dopingType->id);

            return [
                'ads' => $ads,
                'category' => $category,
            ];
        }
    }
}
