<?php namespace Visiosoft\DopingsModule\Doping\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Carbon\Carbon;
use Visiosoft\DopingsModule\Doping\Table\DopingTableBuilder;
use Visiosoft\DopingsModule\Events\DopingApproved;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;

class Approve extends ActionHandler
{
    public function handle(DopingTableBuilder $builder, array $selected, TypeRepositoryInterface $typeRepository)
    {
        $model = $builder->getTableModel();
        $now = Carbon::now();

        foreach ($selected as $id) {
            $doping = $model->newQuery()->find($id);
            $dopingDuration = $typeRepository->find($doping->doping_type_id);

            if ($doping->status !== 'approved') {
                $doping->update([
                    'status' => 'approved',
                    'expiry_date' => $now->addDays($dopingDuration->duration),
                ]);

                event(new DopingApproved($doping));
            }
        }

        if ($selected) {
            $this->messages->success(trans('visiosoft.module.advs::field.approved'));
        }
    }
}