<?php namespace Visiosoft\DopingsModule\Package\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class PackageTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'type',
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'category',
        'type',
        'interval' => [
            'value' => '{entry.interval} {entry.interval_period}'
        ],
        'price' => [
            'value' => '{entry.price} {{setting_value("streams::currency")}}'
        ],
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
