<?php namespace Visiosoft\DopingsModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Twig\TwigFunction;
use Visiosoft\DopingsModule\Doping\Command\getAdsByCatAndDopingType;
use Visiosoft\DopingsModule\Doping\Command\getFeatures;

class DopingsModulePlugin extends Plugin
{

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'getFeatures',
                function ($type) {
                    if (!$ads = $this->dispatch(new getFeatures($type))) {
                        return null;
                    }
                    return $ads;
                }
            ),
            new TwigFunction(
                'getAdsByCatAndDopingType',
                function ($catSlug, $typeSlug) {
                    $ads = $this->dispatch(new getAdsByCatAndDopingType($catSlug, $typeSlug));
                    return $ads['ads'] ? $ads : null;
                }
            ),
        ];
    }
}
