<?php namespace Visiosoft\DopingsModule\Doping\Command;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Doping\DopingModel;

class getFeatures
{
    /**
     * @var $typeId
     */
    protected $typeId;

    /**
     * GetProduct constructor.
     * @param $typeId
     */
    public function __construct($typeId)
    {
        $this->typeId = $typeId;
    }

    /**
     * @param DopingModel $model
     * @param AdvModel $advModel
     * @return mixed
     */
    public function handle(DopingModel $model, AdvModel $advModel)
    {
        $featuredAdvs = $model->getFeaturedAdvs($this->typeId);
        $ads = $advModel->getLocationNames($featuredAdvs);
        foreach ($ads as $index => $ad) {
            $ads[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
            $ads[$index] = $advModel->AddAdsDefaultCoverImage($ad);
        }
        return $ads;
    }
}
